<?php

namespace App\Http\Controllers;

use App\Models\OrderBid;
use App\Models\Orders;
use Illuminate\Http\Request;

class OrdersController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = Orders::with('user','bid')->orderBy('id','desc')->get();
        return response()->json([
            'status'=> 200,
            'message' => "Order retrieved successfully",
            'data' => $data
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        
        $data = new Orders();
        $data->userId = $request->userId;
        $data->loadLocation = $request->loadLocation;
        $data->unLoadLocation = $request->unLoadLocation;
        $data->truckType = $request->truckType;
        $data->qty = $request->qty;
        $data->productDetails = $request->productDetails;
        $data->offerFare = $request->offerFare;
        $data->tripDetails = $request->tripDetails;
        $data->date = $request->date;
        $data->time = $request->time;
        $data->status = $request->status;
        $data->save();  

        return response()->json([
            'status'=> 200,
            'message' => "Order saved successfully",
            'data' => $data
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $data = Orders::with('user','bid')->find($id);
        return response()->json([
            'status'=> 200,
            'message' => "Single Order",
            'data' => $data
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Orders $orders)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $data= Orders::find($id);
        $data->userId = $request->userId;
        $data->loadLocation = $request->loadLocation;
        $data->unLoadLocation = $request->unLoadLocation;
        $data->truckType = $request->truckType;
        $data->qty = $request->qty;
        $data->productDetails = $request->productDetails;
        $data->offerFare = $request->offerFare;
        $data->tripDetails = $request->tripDetails;
        $data->date = $request->date;
        $data->time = $request->time;
        $data->status = $request->status;
        $data->save();  
        return response()->json([
            'status'=> 200,
            'message' => "Order updated successfully",
            'data' => $data
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $order = Orders::find($id);
        $order->delete();
        return response()->json([
            'status'=> 200,
            'message' => "Order deleted successfully",
        ]);
    }

    public function bid (Request $request)
    {
        $data = new OrderBid();
        $data->orderId = $request->orderId;
        $data->bidAmountDriver = $request->bidAmountDriver;
        $data->bidAmountUser = $request->bidAmountUser;
        $data->userId = $request->userId;
        $data->status = $request->status;
        $data->save();
        return response()->json([
            'status'=> 200,
            'message' => "Bid saved successfully",
            'data' => $data
        ]);
    }

    public function bidUpdate (Request $request, $id)
    {
        $data = OrderBid::find($id);
        $data->orderId = $request->orderId;
        $data->bidAmountDriver = $request->bidAmountDriver;
        $data->bidAmountUser = $request->bidAmountUser;
        $data->userId = $request->userId;
        $data->status = $request->status;
        $data->save();
        return response()->json([
            'status'=> 200,
            'message' => "Bid saved successfully",
            'data' => $data
        ]);
    }
}
